%% 2. Load a different mode for the model 
% modeFilaName, of xls file. 
% If modeFileName is empty, will use the mode loaded from the FOMC
%     forecast 
% modeSheetName, in xls file 
% modeNanes, to the loaded mode --can also be top row in the xls sheet 
modePath=settingsFolder; 
modeFileName='lower Rhob'; 
modeSheetName=[]; 

%% 3. Settings for the conditional forecast 
% .matchNames:      Name of the states that must be match in the forecast 
% .matchVal:        Values for the variables in matchNames. If left empty will
%                   use those of the baseline forecast 
% .shocksFree:      Shocks that can be use to hit those values 
% .signalEnd:       Number of last signal to use 
% .shockShutAdd:    Additional shocks to be cancel beyong signals 
% .dateJump:        Jumping date for the forecast 

minforc.matchNames={'FFR','FFR Lead 1','FFR Lead 2','FFR Lead 3','FFR Lead 4','FFR Lead 5',...
    'FFR Lead 6','FFR Lead 7','FFR Lead 8','FFR Lead 9'}; 
minforc.matchVal  ={[],[],[],[],[],[],[],[],[],[]}; 
minforc.shocksFree={'Factor 1','Factor 2','ID Signal 1','ID Signal 2','ID Signal 3','ID Signal 4',...
    'ID Signal 6','ID Signal 7','ID Signal 8','ID Signal 9'}; 
minforc.altName='Faster Deleveraging'; 

minforc.signalEnd=10; 
minforc.shockShutAdd=[]; 
minforc.dateJump=2011.75; 

%% 4. Stochastic Simulations 
% simNrep:          Number of simulations 
% simNames:         Name of the shocks that will be active 
minforc.simNrep=10; 
minforc.simNames={'Discount'}; 


%% 5. Counter defines settings for the variables wish to keep track in the alternative 
counter.names={'GDP','Consumption','Investment','FFR','Hours','PCE Core',...
               'GDPm HP Rule','Marginal Cost','AvgExpInf10y',...
               'FFR Lead 4','FFR Lead 8'}; 
counter.titles= {'GDP (per capita)', 'Consumption (per capita)', 'Investment (per capita)',...
             'Federal Funds Rate', 'Hours (per capita)', 'PCE Core','Gap in Rule','Marginal Cost',...
             'Expected Inflation 10Y',...
             'FFR Lead 4','FFR Lead 8'}; 
counter.scale=[4 4 4 4 1 4 ...
               1 1 4 4 4]; 
              %4*ones(1,add2sol.NLeadsFFRobs)];        
counter.funcmod=[]; 
modeAddSubfolder='Inflation Drift'; 
